import funkin.backend.MusicBeatState;

gameOverSong = "funkmixDeath";
retrySFX = 'funkmix/deathEnd';
lossSFXName = "funkmix/gameOver";
var enterSound:FlxSound = FlxG.sound.load(Paths.sound("funkmix/deathEnd"));

var gameoverSprite:FlxSprite = new FlxSprite();
gameoverSprite.frames = Paths.getFrames("stages/funkmix/pagameover");
gameoverSprite.animation.addByPrefix("death", "pagameover gameover ", 12, false);
gameoverSprite.animation.addByPrefix("enter", "pagameover retry ", 12, false);
gameoverSprite.scale.set(7, 7);
gameoverSprite.updateHitbox();
gameoverSprite.screenCenter();

var end:FlxSprite = new FlxSprite().loadGraphic(Paths.image("stages/funkmix/endScreen"));
end.setGraphicSize(FlxG.width, FlxG.height);
end.updateHitbox();
end.screenCenter();
end.visible = false;

function create () {
	add(gameoverSprite);
	add(end);
	gameoverSprite.animation.play('death');
}

function postCreate() {
	character.visible = false;
	camOver = new FlxCamera(0, 0, 960, 720);
	camOver.bgColor = FlxColor.BLACK;
	FlxG.cameras.add(camOver, false);
	gameoverSprite.cameras = [camOver];
	end.cameras = [camOver];
}

function onEnd(event) {
    event.cancel();
	if (FlxG.sound.music.playing) FlxG.sound.music.stop();
	enterSound.play(true);
	gameoverSprite.animation.play('enter', true);
	trace("entere");
	new FlxTimer().start(2, function(tmr:FlxTimer) end.visible = true);
	new FlxTimer().start(2.3, function(tmr:FlxTimer)
		{
			MusicBeatState.skipTransIn = MusicBeatState.skipTransOut = true;
			FlxG.switchState(new PlayState());	
		});

}